<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> ve stopách</xsl:when>
            <xsl:otherwise> v metrech</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Property Description Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html lang="en">
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Popis vlastností</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Popis vlastností</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky výpisu jsou 
                                                <xsl:value-of select="$unit"/>, pokud není uvedeno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <div style="margin-left:0.5in;margin-right:0.5in">
                                    <xsl:for-each select="HorizontalAlignment">
                                        <table cellpadding="2">
                                            <tbody>
                                                <tr>
                                                    <th align="right" valign="bottom"><br/>Trasa Název:&#xa0; </th>
                                                    <td align="left" valign="bottom"><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" lang="en" valign="top">Trasa Popis:&#xa0; </th>
                                                    <td align="left" valign="top"><xsl:value-of select="@description"/><br/>&#xa0;</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <xsl:apply-templates select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                                        <br/><br/>
                                        <xsl:if test="@area > 0">
                                            Popisovaná parcela má plochu &#xb1;
                                            <xsl:if test="//@linearUnits = 'Imperial'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/> akrů
                                                (<xsl:value-of select="cif:areaFormat(number(@area))"/> st2)
                                            </xsl:if>
                                            <xsl:if test="//@linearUnits = 'Metric'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/> hektarů
                                                (<xsl:value-of select="cif:areaFormat(number(@area))"/> m2)
                                            </xsl:if>
                                        </xsl:if>
                                        <br style="line-height:200%"/>&#xa0;
                                    </xsl:for-each>
                                </div>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Alignment Linear Data -->
    <xsl:template match="HorizontalLine">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v bodě
                <xsl:if test="Start/legalReference">
                    <xsl:if test="Start/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="Start/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
                </xsl:if>
                odtud
                <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@direction))"/>
                (<xsl:value-of select="cif:directionFormat(number(@direction), 2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:when>
            <xsl:when test="position() = last()">
                odtud <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@direction))"/>
                (<xsl:value-of select="cif:directionFormat(number(@direction),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
                <xsl:if test="../../@area > 0"> a Počáteční bod.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                odtud <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@direction))"/>
                (<xsl:value-of select="cif:directionFormat(number(@direction),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Alignment Circular Data -->
    <xsl:template match="HorizontalCircle">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v bodě
                <xsl:if test="Start/legalReference">
                    <xsl:if test="Start/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="Start/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
                </xsl:if>
                odtud podél oblouku 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@radius), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@radius), 2)"/>)
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@chord), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@chord), 2)"/>)
                <xsl:value-of select="$unit"/>,
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:when>
            <xsl:when test="position() = last()">
                odtud podél oblouku 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@radius), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@radius), 2)"/>)
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@chord), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@chord), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="../../@area > 0"> a Počáteční bod.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                odtud podél oblouku 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                o poloměru
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@radius), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@radius), 2)"/>)
                <xsl:value-of select="$unit"/>,
                s tětivou 
                <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@chord), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@chord), 2)"/>)
                <xsl:value-of select="$unit"/>,
                <xsl:if test="position() = last()"> a Počáteční bod.</xsl:if>
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Alignment Spiral Data -->
    <xsl:template match="HorizontalSpiral">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v bodě
                <xsl:if test="Start/legalReference">
                    <xsl:if test="Start/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - Start/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="Start/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="Start/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
                </xsl:if>
                odtud podél přechodnice 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                s tětivou  <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@longChord), 2)))"/>
                <xsl:value-of select="$unit"/>,
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:when>
            <xsl:when test="position() = last()">
                odtud podél přechodnice 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                s tětivou  <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@longChord), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@longChord), 2)"/>)
                <xsl:value-of select="$unit"/>,
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
                <xsl:if test="../../@area > 0"> a Počáteční bod.</xsl:if>
            </xsl:when>
            <xsl:otherwise>
                odtud podél přechodnice 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@length), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@length), 2)"/>)
                <xsl:value-of select="$unit"/>
                <xsl:if test="@rotationDirection = 'cw'"> doprava, </xsl:if>
                <xsl:if test="@rotationDirection = 'ccw'"> doleva, </xsl:if>
                s tětivou  <xsl:value-of select="cif:directionFormatLongCardinalDirectionsAndSymbolsAndNumbers(number(@chordDirection))"/>
                (<xsl:value-of select="cif:directionFormat(number(@chordDirection),  2)"/>)
                ve vzdálenosti 
                <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(@longChord), 2)))"/>
                (<xsl:value-of select="cif:distanceFormat(number(@longChord), 2)"/>)
                <xsl:value-of select="$unit"/>,
                <xsl:if test="position() = last()"> a Počáteční bod.</xsl:if>
                <xsl:if test="End/legalReference">
                    k bodu 
                    <xsl:if test="End/legalReference/@offset >= 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0">
                        <xsl:value-of select="cif:numberToName(string(cif:distanceFormat(number(0 - End/legalReference/@offset), 2)))"/>
                        (<xsl:value-of select="cif:distanceFormat(number(0 - End/legalReference/@offset), 2)"/>)
                    </xsl:if>
                    <xsl:value-of select="$unit"/>
                    <xsl:if test="End/legalReference/@offset >= 0"> vpravo </xsl:if>
                    <xsl:if test="End/legalReference/@offset &lt; 0"> vlevo </xsl:if>
                    od <xsl:value-of select="End/legalReference/@referenceAlignment"/>
                    ve staničení 
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                 Pro tento výpis musíte vybrat nejméně jedno uzavřené směrové řešení v <em>Zahrnout</em> v
                <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em> nebo <em>Nástroje &gt; XML 
                Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Tento výpis pracuje s i bez referenční trasy zadané v <em>Referenní trasy &gt; Zahrnout</em> v <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em>.
							
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
